<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\Model;

use XCart\Extender\Mapping\Extender;
use Doctrine\ORM\Mapping as ORM;

/**
 * Currency
 * @Extender\Mixin
 */
class Currency extends \XLite\Model\Currency
{
    /**
     * Active currency
     *
     * @var \XC\MultiCurrency\Model\ActiveCurrency
     *
     * @ORM\OneToOne (targetEntity="XC\MultiCurrency\Model\ActiveCurrency", mappedBy="currency")
     */
    protected $active_currency;

    /**
     * Check if currency is active multicurrency
     *
     * @return boolean
     */
    public function isActiveMultiCurrency()
    {
        $activeCurrency = $this->getActiveCurrency();

        return isset($activeCurrency) ? true : false;
    }

    /**
     * Set active_currency
     *
     * @param \XC\MultiCurrency\Model\ActiveCurrency $activeCurrency
     * @return Currency
     */
    public function setActiveCurrency(\XC\MultiCurrency\Model\ActiveCurrency $activeCurrency = null)
    {
        $this->active_currency = $activeCurrency;
        return $this;
    }

    /**
     * Get active_currency
     *
     * @return \XC\MultiCurrency\Model\ActiveCurrency
     */
    public function getActiveCurrency()
    {
        return $this->active_currency;
    }
}
