<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\Model;

use Doctrine\ORM\Mapping as ORM;
use XCart\Extender\Mapping\Extender;

/**
 * Country
 *
 * @ORM\Table (indexes={
 *     @ORM\Index (name="active_currency", columns={"active_currency"})
 * })
 * @ORM\MappedSuperclass
 * @Extender\Mixin
 */
class Country extends \XLite\Model\Country
{
    /**
     * Active currencies
     *
     * @var \XC\MultiCurrency\Model\ActiveCurrency
     *
     * @ORM\ManyToOne (targetEntity="XC\MultiCurrency\Model\ActiveCurrency", inversedBy="countries")
     * @ORM\JoinColumn (name="active_currency", referencedColumnName="active_currency_id", onDelete="SET NULL")
     */
    protected $active_currency;

    /**
     * Check if country has assigned currencies
     *
     * @return boolean
     */
    public function hasAssignedCurrencies()
    {
        return $this->getRepository()->hasAssignedCurrencies($this);
    }

    /**
     * Set active_currency
     *
     * @param \XC\MultiCurrency\Model\ActiveCurrency $activeCurrency
     * @return Country
     */
    public function setActiveCurrency(\XC\MultiCurrency\Model\ActiveCurrency $activeCurrency = null)
    {
        $this->active_currency = $activeCurrency;
        return $this;
    }

    /**
     * Get active_currency
     *
     * @return \XC\MultiCurrency\Model\ActiveCurrency
     */
    public function getActiveCurrency()
    {
        return $this->active_currency;
    }
}
