<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\Model;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\Geolocation")
 */
class ActiveCurrencyGeolocation extends \XC\MultiCurrency\Model\ActiveCurrency
{
    /**
     * Return first assigned country
     *
     * @return \XLite\Model\Country
     */
    public function getFirstCountry()
    {
        $countries = $this->getCountries();

        $data = \XC\Geolocation\Logic\Geolocation::getInstance()->getLocation(new \XC\Geolocation\Logic\GeoInput\IpAddress());

        if (isset($data['country'])) {
            foreach ($countries as $country) {
                if ($data['country'] == $country->getCode()) {
                    return $country;
                }
            }
        }

        return parent::getFirstCountry();
    }
}
