<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\Core;

use Symfony\Component\HttpClient\HttpClient;
use XC\MultiCurrency\Core\RateProvider\ARateProvider;
use XC\MultiCurrency\Core\RateProvider\FreeCurrencyConverterAPI;
use XC\MultiCurrency\Core\RateProvider\PremiumCurrencyConverterAPI;
use XC\MultiCurrency\Core\RateProvider\PrepaidCurrencyConverterAPI;
use XC\MultiCurrency\Model\Currency;
use XCart\Container;

class CurrencyRate extends \XLite\Base
{
    public const PROVIDER_NONE                           = 'none';
    public const PROVIDER_FREE_CURRENCY_CONVERTER_API    = 'free_currency_converter_api';
    public const PROVIDER_PREPAID_CURRENCY_CONVERTER_API = 'currency_converter_api';
    public const PROVIDER_PREMIUM_CURRENCY_CONVERTER_API = 'premium_currency_converter_api';

    /**
     * @var ARateProvider
     */
    protected $rateProvider = null;

    /**
     * @param string $to Destination currency code (alpha-3)
     *
     * @return float
     */
    public function getRate($to)
    {
        /** @var Currency $currency */
        $currency = \XLite\Core\Database::getRepo('XLite\Model\Currency')->find(
            \XLite\Core\Config::getInstance()->General->shop_currency
        );

        $from = $currency->getCode();

        return $this->getRateProvider()->getRate($from, $to);
    }

    /**
     * @return ARateProvider
     */
    protected function detectRateProvider()
    {
        return match (\XLite\Core\Config::getInstance()->XC->MultiCurrency->rateProvider) {
            static::PROVIDER_PREPAID_CURRENCY_CONVERTER_API => new PrepaidCurrencyConverterAPI(HttpClient::create()),
            static::PROVIDER_PREMIUM_CURRENCY_CONVERTER_API => new PremiumCurrencyConverterAPI(HttpClient::create()),
            default => $this->getFreeCurrencyConverterAPI(),
        };
    }

    protected function getFreeCurrencyConverterAPI(): FreeCurrencyConverterAPI
    {
        /** @noinspection PhpIncompatibleReturnTypeInspection */
        /** @noinspection NullPointerExceptionInspection */
        return Container::getContainer()->get(FreeCurrencyConverterAPI::class);
    }

    /**
     * Protected constructor.
     * It's not possible to instantiate a derived class (using the "new" operator)
     * until that child class is not implemented public constructor
     *
     * @return void
     */
    protected function __construct()
    {
        parent::__construct();

        $this->rateProvider = $this->detectRateProvider();
    }

    /**
     * @return ARateProvider
     */
    protected function getRateProvider()
    {
        return $this->rateProvider;
    }
}
