<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\Core;

use XCart\Extender\Mapping\Extender;
use XC\MultiCurrency\Core\MultiCurrency;

/**
 * Misceleneous conversion routines
 * @Extender\Mixin
 */
class Converter extends \XLite\Core\Converter
{
    /**
     * Selected multi currency
     *
     * @var \XC\MultiCurrency\Model\ActiveCurrency
     */
    protected $selectedMultiCurrency = null;

    /**
     * Convert price to selected currency according to rate
     *
     * @param float $value Value
     *
     * @return float
     */
    public function convertToSelectedMultiCurrency($value)
    {
        if (
            MultiCurrency::getInstance()->hasMultipleCurrencies()
            && !$this->getSelectedMultiCurrency()->isDefaultCurrency()
        ) {
            $value = MultiCurrency::getInstance()->convertValueByRate(
                $value,
                $this->getSelectedMultiCurrency()->getRate()
            );
        }

        return $value;
    }

    /**
     * Get selected currency
     *
     * @return \XC\MultiCurrency\Model\ActiveCurrency
     */
    protected function getSelectedMultiCurrency()
    {
        if (is_null($this->selectedMultiCurrency)) {
            $this->selectedMultiCurrency = MultiCurrency::getInstance()->getSelectedMultiCurrency();
        }

        return $this->selectedMultiCurrency;
    }
}
