<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\Controller\Customer;

use XCart\Extender\Mapping\Extender;

/**
 * Change customer currency
 * @Extender\Mixin
 * @Extender\Depend ("XC\Geolocation")
 */
class ChangeCurrencyGeolocation extends \XC\MultiCurrency\Controller\Customer\ChangeCurrency
{
    /**
     * Do action 'update'
     *
     * @return void
     */
    protected function doActionUpdate()
    {
        $country = \XLite\Core\Database::getRepo('XLite\Model\Country')->findOneBy(
            [
                'code' => \XLite\Core\Request::getInstance()->country_code
            ]
        );

        $currentLocation = \XC\Geolocation\Logic\Geolocation::getInstance()->getLocation(new \XC\Geolocation\Logic\GeoInput\IpAddress());

        $changeCountry = isset($country) && $country->getEnabled()
            && (!isset($currentLocation['country']) || $currentLocation['country'] !== $country->getCode());

        if ($changeCountry) {
            $address = $this->getCart() && $this->getCart()->getProfile() && $this->getCart()->getProfile()->getShippingAddress()
                ? $this->getCart()->getProfile()->getShippingAddress()
                : null;
            if (!$address) {
                $location = [
                    'country' => $country->getCode(),
                ];

                \XC\Geolocation\Logic\Geolocation::getInstance()->setCachedLocation($location);
            } else {
                $address->setCountry($country);

                $address->setType(
                    \XLite\Core\Request::getInstance()->address_type ?: \XLite\Core\Config::getInstance()->Shipping->anonymous_address_type
                );

                $address->update();

                $this->updateCart(true);
            }
        }

        parent::doActionUpdate();
    }
}
