<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\Action\Storefront\Currency\Assembler\Criteria;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetList\Criteria\FindListCriteriaAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\FindListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\BooleanValue;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\BooleanFilterStrategyType;
use XCart\Bundle\DoctrineBridgeBundle\Enum\OrderRuleDirection;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\DTO\Doctrine\Storefront\Currency\OrderRule;
use XCart\DTO\Doctrine\Storefront\Currency\Filter;

class FindListCriteriaAssemblerDecorator implements FindListCriteriaAssemblerInterface
{
    public function __construct(
        private FindListCriteriaAssemblerInterface $inner,
    ) {
    }

    public function assemble(RequestInterface $request): FindListCriteria
    {
        $criteria = $this->inner->assemble($request);

        /** @var OrderRule $orderRule */
        $orderRule = $criteria->getOrderRule();
        $orderRule->setPosition(OrderRuleDirection::ASC());

        /** @var Filter $filter */
        $filter = $criteria->getFilter();
        $filter->setEnabled(
            (new BooleanValue())
                ->setValue(true)
                ->setStrategy(BooleanFilterStrategyType::EXACT())
        );

        return $criteria;
    }
}
