<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\API\Endpoint\Storefront\Currency\GetOneByCleanURL\Assembler;

use ApiPlatform\Exception\ItemNotFoundException;
use XC\MultiCurrency\Model\ActiveCurrency;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Factory\Logic\Action\Storefront\Currency\GetOne\DTO\RequestInterface as RequestFactory;

class RequestAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private RequestFactory $requestFactory,
        private ReadRepositoryInterface $pageRepository
    ) {
    }

    public function assemble($id): RequestInterface
    {
        /** @var ActiveCurrency $page */
        $activeCurrency = $this->pageRepository->createQueryBuilder('entity')
            ->linkInner('entity.currency', 'currency')
            ->andWhere('currency.code = :code')
            ->setParameter('code', $id)
            ->getSingleResult();

        if (!$activeCurrency) {
            throw new ItemNotFoundException("Active currency with code {$id} not found");
        }

        return $this->requestFactory->create()->setId($activeCurrency->getId());
    }
}
