<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MultiCurrency\API\Endpoint\Order\Transformer;

use Exception;
use XC\MultiCurrency\API\Endpoint\Order\DTO\BaseOutput as DecoratedOutputDTO;
use XC\MultiCurrency\Model\Order as DecoratedOrder;
use XCart\Extender\Mapping\Extender;
use XLite\API\Endpoint\Order\DTO\BaseOutput;
use XLite\Model\Order;

/**
 * @Extender\Mixin
 */
class OutputTransformerAbstract extends \XLite\API\Endpoint\Order\Transformer\OutputTransformerAbstract
{
    /**
     * @param Order|DecoratedOrder $object
     * @throws Exception
     */
    protected function basicTransform(BaseOutput $dto, $object, string $to, array $context = []): BaseOutput
    {
        /** @var DecoratedOutputDTO $output */
        $output = parent::basicTransform($dto, $object, $to, $context);

        $output->selected_multi_currency = $object->getSelectedMultiCurrency() ? $object->getSelectedMultiCurrency()->getCode() : null;
        $output->selected_multi_currency_rate = $object->getSelectedMultiCurrencyRate();

        return $output;
    }
}
