<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\XDependencies\Controller\Admin;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Auth;

/**
 * MailChimp customer subscriptions
 *
 * @Extender\Mixin
 * @Extender\Depend ("XC\MultiVendor")
 */
class MailchimpSubscriptions extends \XC\MailChimp\Controller\Admin\MailchimpSubscriptions
{
    /**
     * Check ACL permissions
     *
     * @return boolean
     */
    public function checkACL()
    {
        return parent::checkACL() || Auth::getInstance()->isVendor();
    }
}
