<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\Tabs;

use XCart\Extender\Mapping\ListChild;

/**
 * @ListChild (list="admin.center", zone="admin", weight="100")
 */
class MailChimp extends \XLite\View\Tabs\ATabs
{
    /**
     * @return array
     */
    public static function getAllowedTargets()
    {
        return array_merge(
            parent::getAllowedTargets(),
            [
                'mailchimp_options',
                'mailchimp_store_data',
                'mailchimp_lists'
            ]
        );
    }

    protected function defineTabs()
    {
        $result = [
            'mailchimp_options' => [
                'weight'     => 100,
                'title'      => static::t('Connection & settings'),
                'url_params' => ['section' => 'settings'],
                'widget'     => 'XC\MailChimp\View\Settings\MailChimpAPISettings',
            ]
        ];

        if (\XC\MailChimp\Core\MailChimp::hasAPIKey()) {
            $result['mailchimp_store_data'] = [
                'weight'   => 200,
                'title'    => static::t('eCommerce Features'),
                'template' => 'modules/XC/MailChimp/store_data/body.twig',
                'class'    => 'nocapitalize'
            ];
            $result['mailchimp_lists'] = [
                'weight' => 300,
                'title'  => static::t('MailChimp lists'),
                'widget' => 'XC\MailChimp\View\MailChimpLists',
            ];
        }

        return $result;
    }
}
