<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\Tabs;

use XCart\Extender\Mapping\Extender;

/**
 * MailChimp subscriptions tab
 * @Extender\Mixin
 */
abstract class AdminProfile extends \XLite\View\Tabs\AdminProfile
{
    /**
     * Returns the list of targets where this widget is available
     *
     * @return string[]
     */
    public static function getAllowedTargets()
    {
        $list = parent::getAllowedTargets();

        $list[] = 'mailchimp_subscriptions';

        return $list;
    }

    /**
     * @inheritdoc
     */
    protected function defineTabs()
    {
        $result = parent::defineTabs();

        if (
            \XC\MailChimp\Main::isMailChimpConfigured()
            && \XLite\Core\Auth::getInstance()->isPermissionAllowed(\XLite\Model\Role\Permission::ROOT_ACCESS)
        ) {
            $result = $result
                + [
                    'mailchimp_subscriptions' => [
                        'weight'   => 500,
                        'title'    => 'MailChimp news lists',
                        'template' => 'modules/XC/MailChimp/profile/subscriptions_tab.twig',
                    ]
                ];
        }

        return $result;
    }
}
