<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\Tabs;

use XCart\Extender\Mapping\Extender;

/**
 * MailChimp subscriptions tab
 * @Extender\Mixin
 */
abstract class Account extends \XLite\View\Tabs\Account
{
    /**
     * Returns the list of targets where this widget is available
     *
     * @return void
     */
    public static function getAllowedTargets()
    {
        $return = parent::getAllowedTargets();

        $return[] = 'mailchimp_subscriptions';

        return $return;
    }

    /**
     * Check if MailChimp module is configured and have lists
     *
     * @return boolean
     */
    protected function isMailChimpConfigured()
    {
        return \XC\MailChimp\Main::isMailChimpConfigured();
    }

    /**
     * @inheritdoc
     */
    protected function defineTabs()
    {
        $tabs = parent::defineTabs();

        if ($this->isMailChimpConfigured()) {
            $tabs['mailchimp_subscriptions'] = [
                'title'    => static::t('News list subscriptions'),
                'template' => 'modules/XC/MailChimp/profile/subscriptions_tab.twig',
                'weight'   => 500
            ];
        }

        return $tabs;
    }
}
