<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\StoreData;

/**
 * Class Main
 */
class Main extends \XLite\View\AView
{
    /**
     * @inheritDoc
     */
    public static function getAllowedTargets()
    {
        return array_merge(
            parent::getAllowedTargets(),
            [
                'mailchimp_store_data'
            ]
        );
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/XC/MailChimp/store_data/main/body.twig';
    }

    /**
     * @return \XC\MailChimp\Model\MailChimpList[]
     */
    public function getLists()
    {
        /** @var \XC\MailChimp\Model\Repo\MailChimpList $repo */
        $repo = \XLite\Core\Database::getRepo('XC\MailChimp\Model\MailChimpList');

        return $repo->getActiveMailChimpLists();
    }

    /**
     * @param \XC\MailChimp\Model\MailChimpList $list
     */
    public function isChecked(\XC\MailChimp\Model\MailChimpList $list)
    {
        return $list->getStore()
            && $list->getStore()->isMain();
    }

    /**
     * @return string
     */
    public function getGettingStartedURL()
    {
        return 'http://kb.mailchimp.com/integrations/e-commerce/how-to-use-mailchimp-for-e-commerce';
    }
}
