<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\Settings;

use XCart\Extender\Mapping\ListChild;
use XC\MailChimp\Core;

/**
 * @ListChild (list="crud.modulesettings.header", zone="admin", weight="100")
 */
class MailChimpHeader extends \XC\MailChimp\View\Settings\ASettings
{
    /**
     * Register CSS files
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $return = parent::getCSSFiles();
        $return[] = 'main/style.css';

        return $return;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return $this->getDir() . '/header.twig';
    }

    /**
     * Get current sections
     *
     * @return array
     */
    protected function getSections()
    {
        return $this->getAllSections();
    }

    /**
     * Check if widget is visible
     *
     * @return boolean
     */
    protected function isVisible()
    {
        return parent::isVisible()
            && !Core\MailChimp::hasAPIKey();
    }

    /**
     * Get Mailchimp logo url
     *
     * @return string
     */
    public function getLogoUrl()
    {
        return \XLite\Core\Layout::getInstance()->getResourceWebPath($this->getDir() . '/images/logo.png');
    }
}
