<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\Model;

/**
 * Settings dialog model widget
 */
class MailChimpSegment extends \XLite\View\Model\AModel
{
    /**
     * Schema default
     *
     * @var array
     */
    protected $schemaDefault = [
        'useOrdersLastMonth'    => [
            self::SCHEMA_CLASS      => 'XLite\View\FormField\Select\YesNo',
            self::SCHEMA_LABEL      => 'Filter by order frequency',
            self::SCHEMA_REQUIRED   => false,
        ],
        'ordersLastMonth'       => [
            self::SCHEMA_CLASS      => 'XLite\View\FormField\Input\Text\Integer',
            self::SCHEMA_LABEL      => 'Orders last month',
            self::SCHEMA_REQUIRED   => false,
            self::SCHEMA_DEPENDENCY => [
                self::DEPENDENCY_SHOW   =>  [
                    'useOrdersLastMonth'    => 'Y',
                ]
            ],
        ],
        'useOrderAmount'        => [
            self::SCHEMA_CLASS      => 'XLite\View\FormField\Select\YesNo',
            self::SCHEMA_LABEL      => 'Filter by order amount',
            self::SCHEMA_REQUIRED   => false,
        ],
        'orderAmount'           => [
            self::SCHEMA_CLASS      => 'XLite\View\FormField\Input\Text\Price',
            self::SCHEMA_LABEL      => 'Total amount of orders',
            self::SCHEMA_REQUIRED   => false,
            self::SCHEMA_DEPENDENCY => [
                self::DEPENDENCY_SHOW   =>  [
                    'useOrderAmount'        => 'Y',
                ]
            ],
        ],
        'useMemberships'        => [
            self::SCHEMA_CLASS      => 'XLite\View\FormField\Select\YesNo',
            self::SCHEMA_LABEL      => 'Filter by profile membership',
            self::SCHEMA_REQUIRED   => false,
        ],
        'memberships'           => [
            self::SCHEMA_CLASS      => 'XLite\View\FormField\Select\Memberships',
            self::SCHEMA_LABEL      => 'Memberships',
            self::SCHEMA_REQUIRED   => false,
            self::SCHEMA_DEPENDENCY => [
                self::DEPENDENCY_SHOW   =>  [
                    'useMemberships'        => 'Y',
                ]
            ],
        ],
        'useProducts'           => [
            self::SCHEMA_CLASS      => 'XLite\View\FormField\Select\YesNo',
            self::SCHEMA_LABEL      => 'Filter by specific products',
            self::SCHEMA_REQUIRED   => false,
        ],
        'products'              => [
            self::SCHEMA_CLASS      => 'XC\MailChimp\View\FormField\Select\SegmentProducts',
            self::SCHEMA_LABEL      => 'Products',
            self::SCHEMA_REQUIRED   => false,
            self::SCHEMA_DEPENDENCY => [
                self::DEPENDENCY_SHOW   =>  [
                    'useProducts'           => 'Y',
                ]
            ],
        ]
    ];

    /**
     * Return current model ID
     *
     * @return integer
     */
    public function getModelId()
    {
        return \XLite\Core\Request::getInstance()->id;
    }

    /**
     * This object will be used if another one is not passed
     *
     * @return \XLite\Model\AEntity
     */
    protected function getDefaultModelObject()
    {
        $model = $this->getModelId()
            ? \XLite\Core\Database::getRepo('\XC\MailChimp\Model\MailChimpSegment')->find(
                $this->getModelId()
            )
            : null;

        return $model ?: new \XC\MailChimp\Model\MailChimpSegment();
    }

    /**
     * Return list of the "Button" widgets
     * Do not use this method if you want sticky buttons panel.
     * The sticky buttons panel class has the buttons definition already.
     *
     * @return array
     */
    protected function getFormButtons()
    {
        $result = parent::getFormButtons();

        $result['update'] = new \XLite\View\Button\Submit(
            [
                \XLite\View\Button\AButton::PARAM_LABEL     => 'Update',
                \XLite\View\Button\AButton::PARAM_BTN_TYPE  => 'regular-main-button',
                \XLite\View\Button\AButton::PARAM_STYLE     => 'action',
            ]
        );

        $result['back'] = new \XLite\View\Button\Link(
            [
                \XLite\View\Button\AButton::PARAM_LABEL     => 'Back to segments list',
                \XLite\View\Button\Link::PARAM_LOCATION     => \XLite\Core\Converter::buildURL(
                    'mailchimp_list_segments',
                    '',
                    [
                        'id'    => $this->getModelObject()->getList()->getId()
                    ]
                ),
                \XLite\View\Button\AButton::PARAM_STYLE     => 'action always-enabled',
            ]
        );

        return $result;
    }

    /**
     * Return name of web form widget class
     *
     * @return string
     */
    protected function getFormClass()
    {
        return '\XC\MailChimp\View\Form\Model\MailChimpSegment';
    }

    /**
     * Populate model object properties by the passed data
     *
     * @param array $data Data to set
     *
     * @return void
     */
    protected function setModelProperties(array $data)
    {
        $memberships = $data['memberships'] ?? [];
        unset($data['memberships']);

        $products = $data['products'] ?? [];
        unset($data['products']);

        foreach (['useOrdersLastMonth', 'useOrderAmount', 'useMemberships', 'useProducts'] as $field) {
            $data[$field] = $data[$field] === 'Y';
        }

        parent::setModelProperties($data);

        /**
         * @var \XC\MailChimp\Model\MailChimpSegment $model MailChimp segment
         */
        $model = $this->getModelObject();
        $model->getMemberships()->clear();

        if (
            isset($memberships)
            && $memberships
        ) {
            foreach ($memberships as $mid) {
                $membership = \XLite\Core\Database::getRepo('XLite\Model\Membership')->find($mid);

                if ($membership) {
                    $model->addMemberships($membership);
                    $membership->addProduct($model);
                }
            }
        } else {
            $model->setUseMemberships(false);
        }

        // Update products
        foreach ($model->getProducts() as $product) {
            $model->getProducts()->removeElement($product);
        }

        if (
            isset($products)
            && $products
        ) {
            foreach ($products as $pid) {
                $product = \XLite\Core\Database::getRepo('XLite\Model\Product')->find($pid);

                if ($product) {
                    $model->addProducts($product);
                }
            }
        } else {
            $model->setUseProducts(false);
        }
    }
}
