<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\Menu\Admin\LeftMenu;

use XC\MailChimp\Main;
use XLite\Core\View\DynamicWidgetInterface;

/**
 * Sales
 */
class Mailchimp extends \XLite\View\Menu\Admin\LeftMenu\ANode implements DynamicWidgetInterface
{
    /**
     * @return int
     */
    protected function getLabel()
    {
        return 1;
    }

    /**
     * @return bool
     */
    protected function showLabel()
    {
        return !\XC\MailChimp\Core\MailChimp::hasAPIKey() && !Main::labelIsShown();
    }

    /**
     * @return array|string[]
     */
    protected function getCacheParameters()
    {
        return array_merge(
            parent::getCacheParameters(),
            Main::getCacheParameters()
        );
    }
}
