<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\Menu\Admin\LeftMenu;

use XC\MailChimp\Main;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Communications extends \XLite\View\Menu\Admin\LeftMenu\Communications
{
    protected function getLabel()
    {
        return !\XC\MailChimp\Core\MailChimp::hasAPIKey() && !Main::labelIsShown();
    }

    /**
     * @return array|string[]
     */
    protected function getCacheParameters()
    {
        return array_merge(
            parent::getCacheParameters(),
            Main::getCacheParameters()
        );
    }
}
