<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\Menu\Admin;

use XCart\Extender\Mapping\Extender;
use XC\MailChimp\View\Menu\Admin\LeftMenu\Mailchimp;

/**
 * @Extender\Mixin
 */
abstract class LeftMenu extends \XLite\View\Menu\Admin\LeftMenu
{
    /**
     * @param array $params Handler params OPTIONAL
     */
    public function __construct(array $params = [])
    {
        $this->relatedTargets['communications'][]     = 'mailchimp_options';
        $this->relatedTargets['communications'][]     = 'mailchimp_store_data';
        $this->relatedTargets['communications'][]     = 'mailchimp_lists';
        $this->relatedTargets['communications'][]     = 'mailchimp_list_segments';
        $this->relatedTargets['communications'][]     = 'mailchimp_list_groups';

        $this->addRelatedTarget('mailchimp_subscriptions', 'customer_profiles', ['profile_type' => 'C'], []);
        $this->addRelatedTarget('mailchimp_subscriptions', 'profile_list', ['profile_type' => 'A'], []);

        parent::__construct($params);
    }

    /**
     * @return array
     */
    protected function defineItems()
    {
        $list = parent::defineItems();

        if (isset($list['communications'])) {
            $list['communications'][static::ITEM_CHILDREN]['mailchimp_integration'] = [
                static::ITEM_TITLE       => static::t('Email Marketing'),
                static::ITEM_TARGET      => 'mailchimp_options',
                static::ITEM_EXTRA       => ['section' => 'settings'],
                static::ITEM_WIDGET      => Mailchimp::class,
                static::ITEM_LABEL_TITLE => static::t('Email Marketing'),
                static::ITEM_LABEL_LINK  => $this->buildURL('mailchimp_options', '', ['section' => 'settings']),
                static::ITEM_WEIGHT      => 250,
            ];
        }

        return $list;
    }
}
