<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\FormField\Select;

use XCart\Domain\ModuleManagerDomain;

class SendCoupons extends \XLite\View\FormField\Select\Regular
{
    public const SEND_ALL   = 'all';
    public const SEND_MATCH = 'match';

    protected ?ModuleManagerDomain $moduleManagerDomain;

    public function __construct(array $params = [])
    {
        $this->moduleManagerDomain = \XCart\Container::getContainer()?->get(ModuleManagerDomain::class);

        parent::__construct($params);
    }

    protected function isVisible()
    {
        return parent::isVisible()
                && $this->moduleManagerDomain->isEnabled('CDev-Coupons');
    }

    /**
     * Return default options list
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        return [
            static::SEND_ALL   => static::t('send all discount coupons'),
            static::SEND_MATCH => static::t('send only discount coupons with matched rules'),
        ];
    }
}
