<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\FormField\Select;

/**
 * Select "Yes / No"
 */
class SegmentProducts extends \XLite\View\FormField\Select\Multiple
{
    /**
     * Return default options list
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        $return = [];

        $products = \XLite\Core\Database::getRepo('XLite\Model\Product')->findBy(
            [
                'useAsSegmentCondition' => true
            ]
        );

        foreach ($products as $product) {
            $return[$product->getProductId()] = $product->getName();
        }

        return $return;
    }
}
