<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\FormField\Select;

/**
 * User type selector
 */
class Lists extends \XLite\View\FormField\Select\Base\Rich
{
    protected function getDefaultOptions()
    {
        $lists = $this->getLists();
        $result = [
            false => ''
        ];

        /** @var \XC\MailChimp\Model\MailChimpList $list */
        foreach ($lists as $list) {
            $result[$list->getId()] = $list->getName();
        }

        return $result;
    }

    /**
     * @return \XC\MailChimp\Model\MailChimpList[]
     */
    public function getLists()
    {
        /** @var \XC\MailChimp\Model\Repo\MailChimpList $repo */
        $repo = \XLite\Core\Database::getRepo('XC\MailChimp\Model\MailChimpList');

        return array_filter(
            $repo->getActiveMailChimpLists(),
            static function ($list) {
                /** @var \XC\MailChimp\Model\MailChimpList $list */
                return $list->getStore()
                    && $list->getStore()->isMain();
            }
        );
    }
}
