<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\FormField\Select;

/**
 * Select "Yes / No"
 */
class ElementType extends \XLite\View\FormField\Select\Regular
{
    public const SELECT = 'select';
    public const CHECKBOX = 'checkbox';

    /**
     * Return default options list
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        return [
            self::SELECT    => static::t('Type: select box'),
            self::CHECKBOX  => static::t('Type: checkbox')
        ];
    }
}
