<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\View\Body;

use XCart\Extender\Mapping\ListChild;

/**
 * @ListChild (list="body", zone="customer", weight="1999999")
 */
class Mcjs extends \XLite\View\AView
{
    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/XC/MailChimp/body/parts/mcjs.twig';
    }

    /**
     * @param $trim
     * @return string
     */
    protected function getMcjsContent($trim = false)
    {
        $script = \XLite\Core\Config::getInstance()->XC->MailChimp->mcjs;

        if ($trim) {
            $script = str_replace(['<script id="mcjs">', '</script>'], '', $script);
        }

        return $script;
    }

    /**
     * @return bool
     */
    protected function isVisible()
    {
        return (bool)\XLite\Core\Config::getInstance()->XC->MailChimp->mcjs;
    }
}
