<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Module\XC\ProductVariants\Model;

use XCart\Extender\Mapping\Extender;

/**
 * Class ProductVariant
 *
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
class ProductVariant extends \XC\ProductVariants\Model\ProductVariant
{
    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return array
     */
    protected function getParamsForFrontURL($withAttributes = false)
    {
        $result = [
            'product_id'        => $this->getProduct()->getProductId(),
        ];

        if ($withAttributes) {
            $result['attribute_values'] = $this->getAttributeValuesParams();
        }

        return $result;
    }

    /**
     * @return string
     */
    protected function getAttributeValuesParams()
    {
        $validAttributes = array_filter(
            $this->getValues(),
            static function ($attr) {
                return $attr &&  $attr->getAttribute();
            }
        );

        $paramsStrings = array_map(
            static function ($attr) {
                return $attr->getAttribute()->getId() . '_' . $attr->getId();
            },
            $validAttributes
        );

        return trim(join(',', $paramsStrings), ',');
    }

    /**
     * @return string
     */
    public function getFrontURLForMailChimp(): ?string
    {
        return $this->getProduct() && $this->getId()
            ? \XLite::getInstance()->getShopURL(
                \XLite\Core\Converter::buildURL(
                    'product',
                    '',
                    $this->getParamsForFrontURL(true),
                    \XLite::getCustomerScript()
                )
            )
            : null;
    }
}
