<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Module\XC\ProductVariants\Logic\DataMapper;

use XCart\Extender\Mapping\Extender;

/**
 * Class Product
 *
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
class Variant extends \XC\MailChimp\Logic\DataMapper\Variant
{
    /**
     * @param \XC\MailChimp\Module\XC\ProductVariants\Model\ProductVariant|\XC\ProductVariants\Model\ProductVariant $variant
     *
     * @return array
     */
    public static function getVariantDataByProductVariant(\XC\ProductVariants\Model\ProductVariant $variant): array
    {
        $imageUrl = $variant->getImage()
            ? $variant->getImage()->getFrontURL()
            : $variant->getProduct()->getImageURL();

        return [
            'id'                    => (string) $variant->getId(),
            'title'                 => $variant->getProduct()->getName(),
            'url'                   => $variant->getFrontURLForMailChimp(),
            'sku'                   => $variant->getDisplaySku(),
            'price'                 => $variant->getDisplayPrice(),
            'inventory_quantity'    => $variant->getPublicAmount(),
            'image_url'             => $imageUrl ?: ''
        ];
    }
}
