<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Module\XC\ProductVariants\Logic\DataMapper;

use XCart\Extender\Mapping\Extender;
use XC\MailChimp\Logic\DataMapper\Variant;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
class Product extends \XC\MailChimp\Logic\DataMapper\Product
{
    /**
     * @param \XLite\Model\Product|\XC\ProductVariants\Model\Product $product
     *
     * @return array
     */
    protected static function getVariantsByProductData(\XLite\Model\Product $product): array
    {
        if (!$product->hasVariants()) {
            return parent::getVariantsByProductData($product);
        }

        $result = [];

        /** @var \XC\ProductVariants\Model\ProductVariant $variant */
        foreach ($product->getVariants() as $variant) {
            /** @see \XC\MailChimp\Module\XC\ProductVariants\Logic\DataMapper\Variant::getVariantDataByProductVariant() */
            $result[] = Variant::getVariantDataByProductVariant($variant);
        }

        return $result;
    }

    /**
     * @param \XLite\Model\OrderItem|\XC\ProductVariants\Model\OrderItem $item
     *
     * @return array
     */
    protected static function getVariantsByOrderItemData(\XLite\Model\OrderItem $item): array
    {
        if (!$item->getObject()) {
            return parent::getVariantsByOrderItemData($item);
        }

        return static::getVariantsByProductData($item->getObject());
    }
}
