<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Module\XC\ProductVariants\Logic\DataMapper;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
class Line extends \XC\MailChimp\Logic\DataMapper\Line
{
    /**
     * @param \XLite\Model\OrderItem $item
     *
     * @return array
     */
    public static function getDataByOrderItem(\XLite\Model\OrderItem $item)
    {
        /** @var \XLite\Model\OrderItem|\XC\ProductVariants\Model\OrderItem $item */
        $result = parent::getDataByOrderItem($item);

        if ($item->getVariant()) {
            $result['product_variant_id'] = (string) $item->getVariant()->getId();
        }

        return $result;
    }
}
