<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Module\XC\MultiVendor\Model;

use XCart\Extender\Mapping\Extender;

/**
 * Class Cart
 *
 * @Extender\Mixin
 * @Extender\Depend ("XC\MailChimp")
 * @Extender\Depend ("XC\MultiVendor")
 */
abstract class Cart extends \XLite\Model\Cart
{
    /**
     * Check if the order needs to send ECommerce360 data
     *
     * @return boolean
     */
    protected function isECommerce360Order()
    {
        return parent::isECommerce360Order()
            && $this->getOrderNumber();
    }

    /**
     * @return bool
     */
    public function isUpdateActionAllowed()
    {
        return !$this->isParent();
    }
}
