<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Module\XC\MultiVendor\Logic\DataMapper;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\MultiVendor")
 */
class Product extends \XC\MailChimp\Logic\DataMapper\Product
{
    /**
     * @param \XLite\Model\OrderItem|\XC\MultiVendor\Model\OrderItem $item
     *
     * @return array
     */
    public static function getDataByOrderItem(\XLite\Model\OrderItem $item): array
    {
        $data = parent::getDataByOrderItem($item);

        if ($item->getVendor()) {
            $data['vendor'] = $item->getVendor()->getVendorCompanyName()
                ?: 'vendor';
        }

        return $data;
    }

    /**
     * @param \XLite\Model\Product|\XC\MultiVendor\Model\Product $product
     *
     * @return array
     */
    public static function getDataByProduct(\XLite\Model\Product $product): array
    {
        $data = parent::getDataByProduct($product);

        if ($product->getVendor()) {
            $data['vendor'] = $product->getVendor()->getVendorCompanyName()
                ?: 'vendor';
        }

        return $data;
    }
}
