<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Model;

use XCart\Extender\Mapping\Extender;
use Doctrine\ORM\Mapping as ORM;

/**
 * @Extender\Mixin
 */
abstract class Product extends \XLite\Model\Product
{
    /**
     * Use product in segment conditions
     *
     * @var boolean
     *
     * @ORM\Column (type="boolean")
     */
    protected $useAsSegmentCondition = false;

    /**
     * Set product_id
     *
     * @return \XLite\Model\Product
     */
    public function setProductId(int $productId)
    {
        $this->product_id = $productId;

        return $this;
    }

    /**
     * @return string
     */
    public function getFrontURLForMailChimp(): string
    {
        return $this->getProductId()
            ? \XLite::getInstance()->getShopURL(
                \XLite\Core\Converter::buildURL(
                    'product',
                    '',
                    $this->getParamsForFrontURL(),
                    \XLite::getCustomerScript()
                )
            )
            : '';
    }

    /**
     * Get useAsSegmentCondition
     *
     * @return boolean
     */
    public function getUseAsSegmentCondition()
    {
        return $this->useAsSegmentCondition;
    }

    /**
     * Set useAsSegmentCondition
     *
     * @param boolean $useAsSegmentCondition
     *
     * @return Product
     */
    public function setUseAsSegmentCondition($useAsSegmentCondition)
    {
        $this->useAsSegmentCondition = $useAsSegmentCondition;

        return $this;
    }

    /**
     * Return list of excluded fields
     *
     * @return array
     */
    public function getExcludedFieldsForMailchimpUpdate(): array
    {
        return ['enabled'];
    }
}
