<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Model;

use XCart\Extender\Mapping\Extender;
use Doctrine\ORM\Mapping as ORM;
use XC\MailChimp\Core;
use XC\MailChimp\Core\MailChimp;
use XC\MailChimp\Main;

/**
 * @Extender\Mixin
 */
class Order extends \XLite\Model\Order
{
    /**
     * Mailchimp store id
     *
     * @var string
     *
     * @ORM\Column (type="string", length=255)
     */
    protected $mailchimpStoreId = '';

    /**
     * Check order statuses
     *
     * @return boolean
     */
    public function checkStatuses()
    {
        $changed = parent::checkStatuses();

        if (
            $changed
            && Main::isMailChimpECommerceConfigured()
        ) {
            \XLite\Core\Database::getEM()->addAfterFlushCallback(function () {
                MailChimp::getInstance()->updateOrder($this);
            });
        }

        return $changed;
    }

    /**
     * Check if the order needs to send ECommerce360 data
     *
     * @return boolean
     */
    protected function isECommerce360Order()
    {
        return $this->isECommerce360Cart();
    }

    /**
     * Check if the order needs to send ECommerce360 data
     *
     * @return boolean
     */
    protected function isECommerce360Cart()
    {
        $request = \XLite\Core\Request::getInstance();

        return isset($request->{Core\Request::MAILCHIMP_CAMPAIGN_ID})
            && !empty($request->{Core\Request::MAILCHIMP_CAMPAIGN_ID})
            && isset($request->{Core\Request::MAILCHIMP_USER_ID})
            && !empty($request->{Core\Request::MAILCHIMP_USER_ID});
    }

    /**
     * @return string
     */
    public function getMailchimpStoreId()
    {
        return $this->mailchimpStoreId;
    }

    /**
     * @param string $mailchimpStoreId
     *
     * @return \XLite\Model\Order
     */
    public function setMailchimpStoreId($mailchimpStoreId)
    {
        $this->mailchimpStoreId = $mailchimpStoreId;
        return $this;
    }
}
