<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Model;

use Doctrine\ORM\Mapping as ORM;

/**
 * MailChimp mail group
 *
 * @ORM\Entity
 * @ORM\Table  (name="mailchimp_list_group")
 */
class MailChimpGroup extends \XLite\Model\AEntity
{
    /**
     * Group ID
     *
     * @var string
     *
     * @ORM\Id
     * @ORM\Column (type="string", length=32)
     */
    protected $id = '';

    /**
     * Group name
     *
     * @var string
     *
     * @ORM\Column (type="string", length=128)
     */
    protected $title = '';

    /**
     * MailChimp parent list
     *
     * @var \XC\MailChimp\Model\MailChimpList
     *
     * @ORM\ManyToOne (targetEntity="XC\MailChimp\Model\MailChimpList", inversedBy="groups")
     */
    protected $list;

    /**
     * Group names
     *
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\OneToMany (targetEntity="XC\MailChimp\Model\MailChimpGroupName", mappedBy="group", cascade={"all"})
     */
    protected $names;

    /**
     * Group type
     *
     * @var string
     *
     * @ORM\Column (type="string", length=128)
     */
    protected $type = '';

    /**
     * Enabled
     *
     * @var boolean
     *
     * @ORM\Column (type="boolean")
     */
    protected $enabled = true;

    /**
     * Constructor
     *
     * @param array $data Entity properties OPTIONAL
     */
    public function __construct(array $data = [])
    {
        $this->names     = new \Doctrine\Common\Collections\ArrayCollection();

        parent::__construct($data);
    }

    /**
     * Set id
     *
     * @param string $id
     * @return MailChimpGroup
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return MailChimpGroup
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set list
     *
     * @param \XC\MailChimp\Model\MailChimpList $list
     * @return MailChimpGroup
     */
    public function setList(\XC\MailChimp\Model\MailChimpList $list = null)
    {
        $this->list = $list;
        return $this;
    }

    /**
     * Get list
     *
     * @return \XC\MailChimp\Model\MailChimpList
     */
    public function getList()
    {
        return $this->list;
    }

    /**
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNames()
    {
        return $this->names;
    }

    /**
     * Get enabled names
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getEnabledNames()
    {
        return $this->getNames()->filter(static function ($name) {
            return $name->getEnabled();
        });
    }

    /**
     * Add group names
     *
     * @param \XC\MailChimp\Model\MailChimpGroupName $names
     * @return MailChimpGroup
     */
    public function addNames(\XC\MailChimp\Model\MailChimpGroupName $names)
    {
        $this->names[] = $names;
        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return boolean
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param boolean $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = (bool)$enabled;
    }
}
