<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Messenger\Message;

class MailChimpRequest
{
    /**
     * @var string
     */
    protected $class;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $method;

    /**
     * @var string
     */
    protected $action;

    /**
     * @var array
     */
    protected $data = [];

    /**
     * @var array
     */
    protected $args = [];

    /**
     * @var int
     */
    protected $timeout;

    /**
     * @param string $class
     * @param string $name
     * @param string $method
     * @param string $action
     * @param array  $data
     * @param array  $args
     * @param int    $timeout
     */
    public function __construct(string $class, string $name, string $method, string $action, array $data = [], array $args = [], int $timeout = 10)
    {
        $this->class   = $class;
        $this->name    = $name;
        $this->method  = $method;
        $this->action  = $action;
        $this->data    = $data;
        $this->args    = $args;
        $this->timeout = $timeout;
    }

    /**
     * @return string
     */
    public function getClass(): string
    {
        return $this->class;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getMethod(): string
    {
        return $this->method;
    }

    /**
     * @return string
     */
    public function getAction(): string
    {
        return $this->action;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @return array
     */
    public function getArgs(): array
    {
        return $this->args;
    }

    /**
     * @return int
     */
    public function getTimeout(): int
    {
        return $this->timeout;
    }
}
