<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Messenger\Handler;

use Symfony\Component\Messenger\Handler\MessageHandlerInterface;
use XC\MailChimp\Messenger\Message\MailChimpRequest;

class MailChimpRequestHandler implements MessageHandlerInterface
{
    public function __invoke(MailChimpRequest $message)
    {
        $className = $message->getClass();
        $request = new $className($message->getData());
        $request->setName($message->getName());
        $request->setMethod($message->getMethod());
        $request->setAction($message->getAction());
        $request->setArgs($message->getArgs());
        $request->setTimeout($message->getTimeout());

        $request->execute();
    }
}
