<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XC\MailChimp\Core\Action\ProductUpdate;
use XC\MailChimp\Main;
use XC\ProductVariants\Model\ProductVariant;
use XLite\InjectLoggerTrait;

final class ProductVariantCallback
{
    use InjectLoggerTrait;

    private function maybeTriggerProductUpdateAction(ProductVariant $variant): void
    {
        if (Main::isMailChimpECommerceConfigured() && Main::getMainStores()) {
            $action = new ProductUpdate($variant->getProduct());
            $action->execute();
        }
    }

    public function postPersist(ProductVariant $variant, LifecycleEventArgs $args)
    {
        if (!$variant->getId()) {
            $variant->setId($args->getObject()->getId());
        }

        $this->maybeTriggerProductUpdateAction($variant);
    }

    public function preUpdate(ProductVariant $variant, LifecycleEventArgs $args)
    {
        $this->maybeTriggerProductUpdateAction($variant);
    }

    public function preRemove(ProductVariant $variant, LifecycleEventArgs $args)
    {
        $this->maybeTriggerProductUpdateAction($variant);
    }
}
