<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\Order;

final class OrderCallback
{
    public function postPersist(Order $order, LifecycleEventArgs $args)
    {
        $order->checkStatuses();
    }

    public function postUpdate(Order $order, LifecycleEventArgs $args)
    {
        $order->checkStatuses();
    }
}
