<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\EntityCallback;

use CDev\Coupons\Module\XC\MailChimp\Core\Action\CouponUpdate;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use XC\MailChimp\Core\MailChimpECommerce;
use XC\MailChimp\Main;

final class CouponCallback
{
    public function preUpdate(\CDev\Coupons\Model\Coupon $coupon, LifecycleEventArgs $args): void
    {
        $changeSet = $args->getObjectManager()->getUnitOfWork()->getEntityChangeSet($coupon);

        if (
            Main::isMailChimpECommerceConfigured() && Main::getMainStores()
            && $coupon->getId()
            && array_filter($changeSet)
        ) {
            $action = new CouponUpdate($coupon);
            $action->execute();
        }
    }

    public function postPersist(\CDev\Coupons\Model\Coupon $coupon, LifecycleEventArgs $args)
    {
        if (Main::isMailChimpECommerceConfigured() && Main::getMainStores()) {
            foreach (Main::getMainStores() as $store) {
                MailChimpECommerce::getInstance()->createCoupon($store->getId(), $coupon);
            }
        }
    }

    public function preRemove(\CDev\Coupons\Model\Coupon $coupon, LifecycleEventArgs $args)
    {
        if (Main::isMailChimpECommerceConfigured() && Main::getMainStores()) {
            foreach (Main::getMainStores() as $store) {
                MailChimpECommerce::getInstance()->removeCoupon(
                    $store->getId(),
                    $coupon->getId()
                );
            }
        }
    }
}
