<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XC\MailChimp\Core\Action\CartUpdate;
use XC\MailChimp\Main;
use XLite\Model\Cart;

final class CartCallback
{
    private function prepareBeforeSave(Cart $cart)
    {
        if (
            $cart->needUpdateMailchimpCart()
            && Main::isMailChimpAbandonedCartEnabled()
            && !$cart->getOrderNumber()
            && $cart->getOrderId()
            && $cart->getProfile()
            && $cart->getProfile()->getEmail()
            && $cart->isUpdateActionAllowed()
        ) {
            $action = new CartUpdate($cart);
            $action->execute();
        }
    }

    public function prePersist(Cart $cart, LifecycleEventArgs $args)
    {
        $this->prepareBeforeSave($cart);
    }

    public function preUpdate(Cart $cart, LifecycleEventArgs $args)
    {
        $this->prepareBeforeSave($cart);
    }
}
