<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Request\Segment;

use XC\MailChimp\Core\Request\MailChimpRequest;

class AddTo extends MailChimpRequest
{
    /**
     * @param array $data
     */
    public function __construct($data)
    {
        $this->data = $data;

        $members = [
            'members_to_add' => array_map(static function ($item) {
                return ['email' => $item];
            }, $this->data['emails']),
        ];

        parent::__construct('Adding to segments', 'post', "lists/{$this->data['listId']}/segments/{$this->data['segmentId']}", $members);
    }

    /**
     * @param string   $listId
     * @param string   $segmentId
     * @param string[] $emails
     *
     * @return self
     */
    public static function getRequest($listId, $segmentId, $emails): self
    {
        return new self([
            'listId' => $listId,
            'segmentId' => $segmentId,
            'emails' => $emails
        ]);
    }

    /**
     * @param string   $listId
     * @param string   $segmentId
     * @param string[] $emails
     *
     * @return void
     */
    public static function scheduleAction($listId, $segmentId, $emails)
    {
        self::getRequest($listId, $segmentId, $emails)->queue();
    }

    /**
     * @param string   $listId
     * @param string   $segmentId
     * @param string[] $emails
     *
     * @return mixed
     */
    public static function executeAction($listId, $segmentId, $emails)
    {
        return self::getRequest($listId, $segmentId, $emails)->execute();
    }
}
