<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Request\Product;

use XC\MailChimp\Core\Request\MailChimpRequest;

class Remove extends MailChimpRequest
{
    /**
     * @param array $data
     */
    public function __construct($data)
    {
        $this->data = $data;

        parent::__construct('Removing product', 'delete', "ecommerce/stores/{$this->data['storeId']}/products/{$this->data['productId']}");
    }

    /**
     * @param string $storeId
     * @param string $productId
     *
     * @return self
     */
    public static function getRequest($storeId, $productId): self
    {
        return new self([
            'storeId' => $storeId,
            'productId' => $productId
        ]);
    }

    /**
     * @param string $storeId
     * @param string $productId
     *
     * @return void
     */
    public static function scheduleAction($storeId, $productId)
    {
        self::getRequest($storeId, $productId)->queue();
    }

    /**
     * @param string $storeId
     * @param string $productId
     *
     * @return mixed
     */
    public static function executeAction($storeId, $productId)
    {
        return self::getRequest($storeId, $productId)->execute();
    }
}
