<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Request\Product;

use XC\MailChimp\Core\Request\MailChimpRequest;

class Create extends MailChimpRequest
{
    /**
     * @param array $data
     */
    public function __construct($data)
    {
        $this->data = $data;

        parent::__construct('Creating product', 'post', "ecommerce/stores/{$this->data['storeId']}/products", $this->data['productData']);
    }

    /**
     * @param string $storeId
     * @param array  $productData
     *
     * @return self
     */
    public static function getRequest($storeId, $productData): self
    {
        return new self([
            'storeId' => $storeId,
            'productData' => $productData
        ]);
    }

    /**
     * @param string $storeId
     * @param array  $productData
     *
     * @return void
     */
    public static function scheduleAction($storeId, $productData)
    {
        self::getRequest($storeId, $productData)->queue();
    }

    /**
     * @param string $storeId
     * @param array  $productData
     *
     * @return mixed
     */
    public static function executeAction($storeId, $productData)
    {
        return self::getRequest($storeId, $productData)->execute();
    }
}
