<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Request\Order;

use XLite\Model\Order;
use XC\MailChimp\Core\Request\MailChimpRequest;
use XC\MailChimp\Logic\DataMapper;

class Update extends MailChimpRequest
{
    /**
     * @param array $data
     */
    public function __construct($data)
    {
        $this->data = $data;

        $order = \XLite\Core\Database::getRepo(Order::class)->find($this->data['orderId']);
        $orderData = DataMapper\Order::getUpdateDataByOrder($order);
        $orderId   = $orderData['id'];

        parent::__construct('Updating order', 'patch', "ecommerce/stores/{$this->data['storeId']}/orders/{$orderId}", $orderData);
    }

    /**
     * @param string $storeId
     * @param Order  $order
     *
     * @return self
     */
    public static function getRequest($storeId, $orderId): self
    {
        return new self([
            'storeId' => $storeId,
            'orderId' => $orderId
        ]);
    }

    /**
     * @param string $storeId
     * @param Order  $order
     *
     * @return void
     */
    public static function scheduleAction($storeId, $orderId)
    {
        self::getRequest($storeId, $orderId)->queue();
    }

    /**
     * @param string $storeId
     * @param int    $orderId
     *
     * @return mixed
     */
    public static function executeAction($storeId, $orderId)
    {
        return self::getRequest($storeId, $orderId)->execute();
    }
}
