<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Request\Customer;

use XLite\Core\Request;
use XC\MailChimp\Core\Request\MailChimpRequest;

class Get extends MailChimpRequest
{
    /**
     * @return string|null
     */
    public static function getUserIdFromRequest(): ?string
    {
        /** @var \XLite\Core\Request|\XC\MailChimp\Core\Request $request */
        $request = Request::getInstance();

        return $request->{$request::MAILCHIMP_USER_ID} ?? null;
    }
}
