<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Request\Cart;

use XC\MailChimp\Core\Request\MailChimpRequest;
use XC\MailChimp\Core\Request\Store as MailChimpStore;

class Remove extends MailChimpRequest
{
    protected $campaignIdFromRequest;

    /**
     * @param array $data
     */
    public function __construct($data)
    {
        $this->data = $data;

        parent::__construct('Removing cart', 'delete', '');
    }

    /**
     * @param int $cartId
     *
     * @return self
     */
    public static function getRequest($cartId): self
    {
        return new self([
            'cartId' => $cartId
        ]);
    }

    /**
     * @param int $cartId
     *
     * @return void
     */
    public static function scheduleAction($cartId)
    {
        self::getRequest($cartId)->queue();
    }

    /**
     * @return array|null
     */
    public function execute(): ?array
    {
        foreach (array_keys(MailChimpStore\Get::getActiveStores($this->campaignIdFromRequest)) as $storeId) {
            Check::dropActionCache($storeId, $this->data['cartId']);

            $this->setAction("ecommerce/stores/{$storeId}/carts/{$this->data['cartId']}");

            parent::execute();
        }

        return null;
    }
}
