<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Request\Audience;

use XC\MailChimp\Core\Request\MailChimpRequest;

class UnSubscribe extends MailChimpRequest
{
    /**
     * @param string $listId
     * @param string $hash
     */
    public function __construct($listId, $hash)
    {
        parent::__construct('UnSubscribe from lists (audience)', 'delete', "lists/{$listId}/members/{$hash}");
    }

    /**
     * @param string $listId
     * @param string $hash
     *
     * @return self
     */
    public static function getRequest($listId, $hash): self
    {
        return new self($listId, $hash);
    }

    /**
     * @param string $listId
     * @param string $hash
     *
     * @return mixed
     */
    public static function executeAction($listId, $hash)
    {
        return self::getRequest($listId, $hash)->execute();
    }
}
