<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Request\Audience;

use XC\MailChimp\Core\Request\MailChimpRequest;

class GetAll extends MailChimpRequest
{
    public function __construct()
    {
        parent::__construct('Getting lists (audience)', 'get', "lists");
    }

    /**
     * @return self
     */
    public static function getRequest(): self
    {
        return new self();
    }

    /**
     * @return mixed
     */
    public static function executeAction()
    {
        $result = self::getRequest()->execute();

        return $result['lists'] ?? null;
    }
}
