<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core;

use XCart\Extender\Mapping\Extender;
use Includes\Utils\URLManager;

/**
 * Request
 * @Extender\Mixin
 */
abstract class Request extends \XLite\Core\Request
{
    public const MAILCHIMP_CAMPAIGN_ID   = 'mc_cid';
    public const MAILCHIMP_USER_ID       = 'mc_eid';
    public const MAILCHIMP_TRACKING_CODE = 'mc_tc';

    public const MAILCHIMP_LANDING_SITE = 'xc_mailchimp_landing_site';

    /**
     * @return string
     */
    public function getLandingSiteForMailchimp(): string
    {
        $data = $this->getData();

        return !empty($data[static::MAILCHIMP_LANDING_SITE])
            ? $data[static::MAILCHIMP_LANDING_SITE]
            : '';
    }

    public function tryToFillLandingSite()
    {
        $data = $this->getGetData(true);

        $mcId      = $this->getCheckedParam(self::MAILCHIMP_CAMPAIGN_ID, $data);
        $utmSource = $this->getCheckedParam('utm_source', $data);

        if ($mcId || $utmSource) {
            $this->setCookie(
                static::MAILCHIMP_LANDING_SITE,
                URLManager::getCurrentURL(),
                \XLite\Core\Converter::getInstance()->time() + 2592000
            );
        }
    }

    /**
     * Process ECommerce360 input data
     *
     * @return void
     */
    public function processECommerce360Data()
    {
        $data = $this->getGetData(true);

        $this->tryToMapParameter(self::MAILCHIMP_CAMPAIGN_ID, $data);
        $this->tryToMapParameter(self::MAILCHIMP_USER_ID, $data);
        $this->tryToMapParameter(self::MAILCHIMP_CAMPAIGN_ID, $data);
    }

    /**
     * @param $name
     * @param $data
     */
    protected function tryToMapParameter($name, $data)
    {
        $param = $this->getCheckedParam($name, $data);

        if ($param) {
            $this->setCookie(
                $name,
                $param,
                \XLite\Core\Converter::getInstance()->time() + 2592000
            );
        }
    }

    /**
     * @param string $name
     * @param array  $data
     *
     * @return string|null
     */
    protected function getCheckedParam($name, $data): ?string
    {
        return !empty($data[$name]) ? $data[$name] : null;
    }
}
