<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Action;

use XLite\Model\Product;
use XC\MailChimp\Core\Request\Product as MailChimpProduct;
use XC\MailChimp\Logic\DataMapper;
use XC\MailChimp\Main;

class ProductUpdate implements IMailChimpAction
{
    /**
     * @var Product
     */
    protected $product;

    /**
     * @param Product $product
     */
    public function __construct(Product $product)
    {
        $this->product = $product;
    }

    public function execute(): void
    {
        foreach (Main::getMainStores() as $store) {
            MailChimpProduct\Update::scheduleAction($store->getId(), DataMapper\Product::getDataByProduct($this->product));
        }
    }
}
