<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Core\Action;

use XC\MailChimp\Core\Request\MailChimpRequest;
use XC\MailChimp\Core\Request\Campaign as MailChimpCampaign;
use XLite\InjectLoggerTrait;
use XLite\Model\Cart;
use XC\MailChimp\Core\Request\Cart as MailChimpCart;
use XC\MailChimp\Logic\DataMapper;

class CartUpdate implements IMailChimpAction
{
    use InjectLoggerTrait;

    /**
     * @var Cart
     */
    private $cart;

    /**
     * @param Cart $cart
     */
    public function __construct(Cart $cart)
    {
        $this->cart = $cart;
    }

    public function execute(): void
    {
        try {
            $campaignIdFromRequest = MailChimpCampaign\Get::getCampaignIdFromRequest();
            $trackingIdFromRequest = MailChimpRequest::getTrackingIdFromRequest();

            $cartData = DataMapper\Cart::getDataByCart($campaignIdFromRequest, $trackingIdFromRequest, $this->cart);
            $productsData = array_map(static function ($item) {
                return DataMapper\Product::getDataByOrderItem($item);
            }, $this->cart->getItems()->toArray());

            MailChimpCart\UpdateOrCreate::scheduleAction($this->cart->getProfile()->getProfileId(), $cartData, $productsData);
        } catch (\Exception $e) {
            $this->getLogger('XC-MailChimp')->debug($e->getMessage());
        }
    }
}
